/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.CallbackInvokator;
import jade.core.CommandProcessor;
import jade.core.Filter;
import jade.core.IMTPException;
import jade.core.IMTPManager;
import jade.core.Node;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.ServiceFinder;
import jade.core.ServiceHelper;
import jade.core.Sink;
import jade.core.VerticalCommand;
import jade.core.behaviours.Behaviour;
import jade.util.Logger;
import jade.util.leap.HashMap;
import jade.util.leap.Map;

public abstract class BaseService
implements Service {
    public static final String MAIN_SLICE = "$$$Main-Slice$$$";
    public static final String THIS_SLICE = "$$$This-Slice$$$";
    private IMTPManager myIMTPManager;
    private CommandProcessor myCommandProcessor = null;
    private Map slices;
    private Map aliases;
    protected ServiceFinder myFinder;
    protected Logger myLogger = Logger.getMyLogger(this.getName());

    public void init(AgentContainer ac, Profile p) throws ProfileException {
        this.myFinder = p.getServiceFinder();
        this.myIMTPManager = p.getIMTPManager();
        this.slices = new HashMap(5);
        this.aliases = new HashMap(1);
        this.myLogger.log(8, "Service " + this.getName() + " initialized");
    }

    void setCommandProcessor(CommandProcessor cp) {
        if (this.myCommandProcessor == null) {
            this.myCommandProcessor = cp;
        }
    }

    public Service.Slice getSlice(String name) throws ServiceException {
        String realName = this.lookupAlias(name);
        Service.Slice s = (Service.Slice)this.slices.get(realName);
        if (s == null) {
            try {
                s = this.myFinder.findSlice(this.getName(), realName);
                this.slices.put(realName, s);
            }
            catch (IMTPException imtpe) {
                throw new ServiceException("IMTP Error while using the Service Finder", imtpe);
            }
        }
        return s;
    }

    public int getNumberOfSlices() {
        return this.slices.size();
    }

    public Node getLocalNode() throws IMTPException {
        return this.myIMTPManager.getLocalNode();
    }

    public Service.Slice[] getAllSlices() throws ServiceException {
        try {
            return this.myFinder.findAllSlices(this.getName());
        }
        catch (IMTPException imtpe) {
            throw new ServiceException("IMTP Error while using the Service Finder", imtpe);
        }
    }

    protected void addAlias(String alias, String name) {
        this.aliases.put(alias, name);
    }

    protected String lookupAlias(String alias) {
        String result = (String)this.aliases.get(alias);
        if (result != null) {
            return result;
        }
        return alias;
    }

    public Filter getCommandFilter(boolean direction) {
        return null;
    }

    public Sink getCommandSink(boolean direction) {
        return null;
    }

    public String[] getOwnedCommands() {
        return null;
    }

    public Class getHorizontalInterface() {
        return null;
    }

    public Service.Slice getLocalSlice() {
        return null;
    }

    public ServiceHelper getHelper(Agent a) throws ServiceException {
        return null;
    }

    public Behaviour getAMSBehaviour() {
        return null;
    }

    public void boot(Profile p) throws ServiceException {
    }

    public void shutdown() {
    }

    public Object submit(VerticalCommand cmd) throws ServiceException {
        String cmdName = cmd.getName();
        String[] ownedCommands = this.getOwnedCommands();
        int i = 0;
        while (i < ownedCommands.length) {
            if (cmdName.equals(ownedCommands[i])) {
                return this.myCommandProcessor.processOutgoing(cmd);
            }
            ++i;
        }
        throw new ServiceException("Command <" + cmdName + "> does not belong to service <" + this.getName() + ">");
    }

    protected Service.Slice getFreshSlice(String name) throws ServiceException {
        this.clearCachedSlice(name);
        return this.getSlice(name);
    }

    void clearCachedSlice(String name) {
        if (this.slices != null) {
            String realName = this.lookupAlias(name);
            this.slices.remove(realName);
        }
    }

    protected CallbackInvokator createInvokator() {
        return new CallbackInvokator();
    }

    public abstract String getName();
}

